//
//  FLCore.h
//  FLCore
//
//  Created by Frankie Laguna on 11/12/13.
//  Copyright (c) 2013 FIPLAB Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "FLCNotifications.h"

#import "FLCWelcome.h"
#import "FLCAnalytics.h"
#import "FLCUpdate.h"
#import "FLCAdNetwork.h"

@interface FLCore : NSObject
+ (instancetype)sharedInstance;

@property (readonly, strong, nonatomic) FLCAnalytics *analytics;
@property (readonly, strong, nonatomic) FLCWelcome *welcome;
@property (readonly, strong, nonatomic) FLCUpdate *update;
@property (readonly, strong, nonatomic) FLCAdNetwork *adNetwork;

@property (readonly, nonatomic) BOOL welcomeVisible;
@property (readonly, nonatomic) BOOL updateVisible;

@property (readonly, nonatomic) BOOL canShowMainWindow;

@property (nonatomic) BOOL runAtLogin;
@property (nonatomic) BOOL showsRunAtLoginButton;

@property (nonatomic) BOOL showsUpsellDialog;
@property (nonatomic) BOOL isMAS;

- (void)applicationDidLaunch;
- (void)showVisibleWindow;

@end
